/*
 * Decompiled with CFR 0.152.
 */
package itx.erp;

import itx.core.web.BaseController;
import itx.erp.base.service.ActivityService;
import itx.erp.base.service.GroupService;
import itx.erp.base.service.UserService;
import itx.erp.base.service.WebSessionService;
import itx.erp.customer.service.CustomerService;
import itx.erp.helper.ErpConfig;
import itx.erp.helper.MyResourceLoader;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.webmail.conf.EmailSettings;
import itx.erp.webmail.service.EmailService;
import java.io.File;
import java.io.InputStream;
import jtbcore.container.ObjectContainer;
import jtbcore.container.UrlBean;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.model.DatabaseModel;
import jtbcore.exception.ContainerException;
import jtbcore.exception.FileException;
import jtbcore.util.AppLogger;
import org.eclipse.jetty.server.LocalConnector;

public class ErpObjectContainer
extends ObjectContainer {
    public static boolean HOSTED = false;
    public static boolean RTOB_ENABLED = true;
    public static boolean CONTRACTS_ENABLED = false;
    public static String CONTEXT_PATH = null;
    protected String dataDir = null;
    protected LocalConnector localConnector;

    public LocalConnector getLocalConnector() {
        return this.localConnector;
    }

    public void setLocalConnector(LocalConnector localConnector) {
        this.localConnector = localConnector;
    }

    public String getDataDir() throws FileException {
        File docs;
        if (this.dataDir != null) {
            return this.dataDir;
        }
        if (ErpConfig.runsAsWinService()) {
            File f = new File("C:\\ProgramData\\");
            if (f.exists() && !(f = new File("C:\\ProgramData\\Contractbeheer")).exists()) {
                try {
                    f.mkdir();
                }
                catch (Exception ex) {
                    f = null;
                    ex.printStackTrace();
                }
            }
            if (!(f != null && f.exists() || (f = new File("C:\\Contractbeheer")).exists())) {
                f.mkdir();
            }
            this.dataDir = f.getAbsolutePath();
            AppLogger.log("Datadir: " + this.dataDir);
            return this.dataDir;
        }
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = new File(".").getAbsolutePath();
        }
        if ((docs = new File(userHome + "/Documents")).exists()) {
            String p = docs.getAbsolutePath() + "/contractbeheer";
            File f = new File(p);
            if (!f.exists() && !f.mkdir()) {
                throw new FileException("Unable to create data dir");
            }
            this.dataDir = f.getAbsolutePath();
        } else {
            File f = new File(userHome + "/contractbeheer");
            if (!f.exists() && !f.mkdir()) {
                throw new FileException("Unable to create data dir");
            }
            this.dataDir = f.getAbsolutePath();
        }
        AppLogger.log("Datadir: " + this.dataDir);
        return this.dataDir;
    }

    public String getTempDir() throws FileException {
        String d = this.getDataDir();
        File ftmp = new File(d + "/tmp");
        if (!ftmp.exists() && !ftmp.mkdir()) {
            throw new FileException("Unable to create temp-folder (" + d + File.separator + "tmp)");
        }
        return ftmp.getAbsolutePath();
    }

    public String getTempFile(String filename) throws FileException {
        String tempDir = ErpObjectContainer.getInstance().getTempDir();
        String p1 = filename;
        String p2 = "";
        if (filename.indexOf(46) != -1) {
            p2 = filename.substring(filename.lastIndexOf(46));
            p1 = filename.substring(0, filename.length() - p2.length());
        }
        String tempfile = null;
        int x = 0;
        while (x <= 10000) {
            tempfile = tempDir + "/" + p1;
            tempfile = x == 0 ? tempfile + p2 : tempfile + "-" + x + p2;
            File f = new File(tempfile);
            if (!f.exists()) break;
            ++x;
        }
        if (tempfile == null) {
            throw new FileException("Error creating temp file");
        }
        return tempfile;
    }

    public void cleanTemp() {
        try {
            File[] files;
            String d = this.getTempDir();
            if (d == null || d.trim().length() == 0) {
                return;
            }
            File ftmp = new File(d);
            if (!ftmp.exists()) {
                return;
            }
            File[] fileArray = files = ftmp.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    f.delete();
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getFilesDir() throws FileException {
        String d = this.getDataDir();
        File ftmp = new File(d + "/files");
        if (!ftmp.exists() && !ftmp.mkdir()) {
            throw new FileException("Unable to create files-folder (" + d + File.separator + "files)");
        }
        return ftmp.getAbsolutePath();
    }

    public static ErpObjectContainer getInstance() {
        if (ObjectContainer.instance == null) {
            ObjectContainer.instance = new ErpObjectContainer();
            MyResourceLoader mrl = new MyResourceLoader();
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream is = mrl.getResource("/itx/erp/base/conf/beans.xml");){
                    ObjectContainer.instance.parseXml(is);
                    ObjectContainer.instance.doAutostart();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (ErpObjectContainer)ObjectContainer.instance;
    }

    public ErpConfig getAppConfig() throws ContainerException {
        return (ErpConfig)this.getBean("appConfig");
    }

    public SqlConnection getSqlConnection() throws ContainerException {
        return (SqlConnection)this.getBean("sqlConnection");
    }

    public DatabaseModel getDmBase() throws ContainerException {
        return (DatabaseModel)this.getBean("dmBase");
    }

    public DatabaseModel getDmCustomer() throws ContainerException {
        return (DatabaseModel)this.getBean("dmCustomer");
    }

    public DatabaseModel getDmContracts() throws ContainerException {
        return (DatabaseModel)this.getBean("dmContracts");
    }

    public DatabaseModel getDmSales() throws ContainerException {
        return (DatabaseModel)this.getBean("dmSales");
    }

    public DatabaseModel getDmRental() throws ContainerException {
        return (DatabaseModel)this.getBean("dmRental");
    }

    public GroupService getGroupService() throws ContainerException {
        return (GroupService)this.getBean("groupService");
    }

    public UserService getUserService() throws ContainerException {
        return (UserService)this.getBean("userService");
    }

    public CustomerService getCustomerService() throws ContainerException {
        return (CustomerService)this.getBean("customerService");
    }

    public WebSessionService getWebSessionService() throws ContainerException {
        return (WebSessionService)this.getBean("webSessionService");
    }

    public SalesSettings getSalesSettings() {
        try {
            return (SalesSettings)this.getBean("salesSettings");
        }
        catch (ContainerException e) {
            throw new RuntimeException(e);
        }
    }

    public DatabaseModel getDmEmail() throws ContainerException {
        return (DatabaseModel)this.getBean("dmEmail");
    }

    public EmailService getEmailService() throws ContainerException {
        return (EmailService)this.getBean("emailService");
    }

    public EmailSettings getEmailSettings() throws ContainerException {
        return (EmailSettings)this.getBean("emailSettings");
    }

    public ActivityService getActivityService() throws ContainerException {
        return (ActivityService)this.getBean("activityService");
    }

    public BaseController getController(String ref) throws ContainerException {
        Object o = this.getBean(ref);
        if (o == null || !(o instanceof BaseController)) {
            return null;
        }
        return (BaseController)o;
    }

    public UrlBean lookupUrl(String u) {
        for (String p : this.urls.keySet()) {
            if (!p.equals(u)) continue;
            return (UrlBean)this.urls.get(p);
        }
        return null;
    }
}

